unit Figure;

interface
uses ExtCtrls, Graphics;

type TMyFigure=class
  private
     x, y, r  : Word;       //     
     FColor   : TColor;     //  
     BColor   : TColor;     //  
     Image    : TImage;     //   
     procedure Clear;       //  
     //  
     procedure DrawFigure; virtual; abstract;
  public
     constructor Create(aImage : TImage;
                 ax, ay, ar : Word; aFColor, aBColor : TColor);
     procedure Draw;                    // 
     procedure ReSize(ar: Word);        //  
     procedure ReColor(acolor: TColor); //  
end;

type TMyCircle=class(TMyFigure)         //  
  public
     procedure DrawFigure; override;    //  
end;

type TMySquare=class(TMyFigure)         //  
  public
     procedure DrawFigure; override;    //  
end;


implementation

procedure TMyCircle.DrawFigure;
begin
 Image.Canvas.Ellipse(x-r, y-r, x+r, y+r);
end;

procedure TMySquare.DrawFigure;
begin
   Image.Canvas.Rectangle(x-r, y-r, x+r, y+r);
end;

//  
constructor TMyFigure.Create(aImage : TImage;
                      ax, ay, ar : Word; aFColor, aBColor : TColor);
begin inherited Create;  //   
  //    Image
  Image:=aImage;
  //   
  x:=ax; y:=ay; r:=ar;
  FColor:=aFColor;
  BColor:=aBColor;
  //   Image
  Image.Canvas.Brush.Style := bsSolid;  //    
end;

//  
procedure TMyFigure.Draw;
begin
  Image.Canvas.Brush.Color := FColor;   //   
  Image.Canvas.Pen.Color := FColor;     //   
  DrawFigure();
end;

//    
procedure TMyFigure.Clear;
begin
  Image.Canvas.Brush.Color := BColor;   //   
  Image.Canvas.Pen.Color := BColor;     //   
  DrawFigure();
end;

//   
procedure TMyFigure.ReSize(ar: Word);
begin
 Clear; r:=ar; Draw;
end;

//   
procedure TMyFigure.ReColor(aColor: TColor);
begin
 Clear; FColor:=aColor; Draw;
end;

end.
